#
#   axe_trace_gen.py
#

import sys
import math
import random
sys.path.append("../common")
from bsg_cache_trace_gen import *



#   main()
if __name__ == "__main__":

  num_instr_p = int(sys.argv[1])  
  seed_p = int(sys.argv[2])
  ways_p = int(sys.argv[3])
  data_width_p = int(sys.argv[4])

  sets_p = 4
  block_size_in_words_p=4
  addr_width_p = 32

  print("# seed_p = " + str(seed_p))

  byte_offset_width = int(math.log(data_width_p>>3,2))
  word_offset_width = int(math.log(block_size_in_words_p,2))
  index_width = int(math.log(sets_p,2))

  random.seed(seed_p)

  tg = BsgCacheTraceGen(addr_width_p,data_width_p)
  print("#### generated by trace_gen.py ####")

  for i in range(sets_p*ways_p):
    tg.send(TAGST, (i<<(byte_offset_width+word_offset_width)), 0)


  store_data = 1
  
  mask = 0b1111 if data_width_p==32 else 0b11111111

  for i in range(num_instr_p):
    load_not_store = random.randint(0,1)
    word_offset = random.randint(0,3)<< (byte_offset_width)
    index = random.randint(0,3) << (byte_offset_width+word_offset_width)
    tag = random.randint(0,15) << (byte_offset_width+word_offset_width+index_width)
    addr = tag + index + word_offset

    if (load_not_store):
      tg.send(LM,addr,0,mask)
    else:
      tg.send(SM,addr,store_data,mask)
      store_data += 1

    delay = random.randint(0,15)

    if (delay == 0):
      continue
    else:
      tg.wait(delay)
