# Contributing to `nvim-web-devicons`

Thank you for your contribution!

## Order

Please ensure `icons_by_filename`, `icons_by_file_extension` and `filetypes` are ordered alphabetically, to prevent merge conflicts.

## Prerequisites

Code is formatted using stylua and linted using luacheck.

You can install these with:
```sh
cargo install stylua
luarocks install luacheck
```

or via your OS package manager e.g. Arch linux:
```sh
pacman -S stylua
pacman -S luacheck
```

## Building

Following your changes, please run:

```sh
make
```

This will:
1. `git clone --depth 1 https://github.com/lifepillar/vim-colortemplate.git vim-colortemplate` if necessary
1. Generate cterm colors
2. Generate light color variants
3. Check style
4. Lint

You can automatically fix any style issues via:
```sh
make style-fix
```

## Generate Colors

Add or update icons in `lua/nvim-web-devicons/icons-default.lua`

There are two tables where icons can be added:
1. icons_by_filename
2. icons_by_file_extension

Add the icon in table 1. if the icon is for a file that is always named that
way, for example `.gitconfig`. Add to table 2. if the icon is for all files
with an extension.

Each icon must have the following (this is an example):
```lua
[".gitconfig"] = {
    icon = "",
    color = "#41535b",
    cterm_color = "0",
    name = "GitConfig",
},
```
___Key/value pairs must appear in the same exact order!___

- `color` must contain a color in the html notation
- `cterm_color` must be below `color`, and it must contain a number (any number)
- the correct value for `cterm_color` will be generated by the script
- `name` must only contain alphanumeric characters (don't use `/`, `-`, `_`)

Ensure your current working directory is the repo root.
Run `make`. This will:
- Update `cterm_color` based on `color`
- Generate `lua/nvim-web-devicons/icons-light.lua`

Please commit both `lua/nvim-web-devicons/icons-default.lua` and `lua/nvim-web-devicons/icons-light.lua`

## Test

Run `:NvimWebDeviconsHiTest` to view the icons and their highlighting.

Start neovim with `TERM=xterm-256color nvim ...` to test cterm.

Check with `&background` `dark` and `light`

## Documentation

When modifying or adding API, please update [Usage](README.md#Usage)

# Pull Request

Please reference any issues in the description e.g. "resolves #1234", which will be closed upon merge.

Please check "allow edits by maintainers" to allow nvim-web-devicons maintainers to make small changes such as documentation tweaks.

## Subject

The merge commit message will be the subject of the PR.

A [Conventional Commits](https://www.conventionalcommits.org/en/v1.0.0) subject will be validated by the Semantic Pull Request Subject CI job. Reference the issue to be used in the release notes e.g.

```
feat: add gradle icons
fix: update rust icon
feat(#192): :NvimWebDeviconsHiTest
```

Available types:
* feat: A new feature
* fix: A bug fix
* docs: Documentation only changes
* style: Changes that do not affect the meaning of the code (white-space, formatting, missing semi-colons, etc)
* refactor: A code change that neither fixes a bug nor adds a feature
* perf: A code change that improves performance
* test: Adding missing tests or correcting existing tests
* build: Changes that affect the build system or external dependencies (example scopes: gulp, broccoli, npm)
* ci: Changes to our CI configuration files and scripts (example scopes: Travis, Circle, BrowserStack, SauceLabs)
* chore: Other changes that don't modify src or test files
* revert: Reverts a previous commit

If in doubt, look at previous commits.

See also [The Conventional Commits ultimate cheatsheet](https://gist.github.com/gabrielecanepa/fa6cca1a8ae96f77896fe70ddee65527)

## Browser Font

It is useful to see the actual glyphs in the pull request. That can be done by setting the browser font to your nerd font.

Using firefox:

* Settings -> General
* Fonts -> Advanced
* Change Monospace to "Hack Nerd Font Mono" or similar
* Uncheck "Allow pages to choose their own fonts, instead of your selections above"
