; OpenGL 3.2 (3 Aug 2009)  GLSL 1.5
(define-library (OpenGL 3.2)
(export
      (exports (OpenGL 3.1))
; OpenGL 3.2 introduced "deprecation" model,
; so i think we should copy all defines here
; and remove old constants

; if you want to enable "deprecated" functionality,
; add corresponding GL_VERSION_x_x_DEPRECATED variable to config

   GL_VERSION_3_2

   GL_VERSION_1_2_DEPRECATED
      GL_RESCALE_NORMAL
      GL_LIGHT_MODEL_COLOR_CONTROL
      GL_SINGLE_COLOR
      GL_SEPARATE_SPECULAR_COLOR
      GL_ALIASED_POINT_SIZE_RANGE

   GL_VERSION_1_3_DEPRECATED
      ;...

   GL_VERSION_1_4_DEPRECATED
      ;...

   GL_VERSION_1_5_DEPRECATED
      ;...

   GL_VERSION_2_0_DEPRECATED
      GL_VERTEX_PROGRAM_TWO_SIDE
      GL_POINT_SPRITE
      GL_COORD_REPLACE
      GL_MAX_TEXTURE_COORDS

   GL_VERSION_2_1_DEPRECATED
      ;...

   GL_VERSION_3_0_DEPRECATED
      ;...
)

; ============================================================================
; == implementation ==========================================================
(import (scheme core)
        (OpenGL config)
        (OpenGL 3.1))

(begin
   (define GL_VERSION_3_2 1)

   (define GL_VERSION_1_2_DEPRECATED (config 'GL_VERSION_1_2_DEPRECATED #f))

   (define GL_RESCALE_NORMAL            (if GL_VERSION_1_2_DEPRECATED GL_RESCALE_NORMAL))
   (define GL_LIGHT_MODEL_COLOR_CONTROL (if GL_VERSION_1_2_DEPRECATED GL_LIGHT_MODEL_COLOR_CONTROL))
   (define GL_SINGLE_COLOR              (if GL_VERSION_1_2_DEPRECATED GL_SINGLE_COLOR))
   (define GL_SEPARATE_SPECULAR_COLOR   (if GL_VERSION_1_2_DEPRECATED GL_SEPARATE_SPECULAR_COLOR))
   (define GL_ALIASED_POINT_SIZE_RANGE  (if GL_VERSION_1_2_DEPRECATED GL_ALIASED_POINT_SIZE_RANGE))


   (define GL_VERSION_1_3_DEPRECATED (config 'GL_VERSION_1_3_DEPRECATED #f))
   
   (define GL_VERSION_1_4_DEPRECATED (config 'GL_VERSION_1_4_DEPRECATED #f))
   
   (define GL_VERSION_1_5_DEPRECATED (config 'GL_VERSION_1_5_DEPRECATED #f))


   (define GL_VERSION_2_0_DEPRECATED (config 'GL_VERSION_2_0_DEPRECATED #f))
   (define GL_VERTEX_PROGRAM_TWO_SIDE   (if GL_VERSION_2_0_DEPRECATED #x8643#|GL_VERTEX_PROGRAM_TWO_SIDE|#))
   (define GL_POINT_SPRITE              (if GL_VERSION_2_0_DEPRECATED #x8861#|GL_POINT_SPRITE|#))
   (define GL_COORD_REPLACE             (if GL_VERSION_2_0_DEPRECATED #x8862#|GL_COORD_REPLACE|#))
   (define GL_MAX_TEXTURE_COORDS        (if GL_VERSION_2_0_DEPRECATED #x8871#|GL_MAX_TEXTURE_COORDS|#))

   
   (define GL_VERSION_2_1_DEPRECATED (config 'GL_VERSION_2_1_DEPRECATED #f))
   
   (define GL_VERSION_3_0_DEPRECATED (config 'GL_VERSION_3_0_DEPRECATED #f))

   ; ...
))