import os
import sys

import gi

gi.require_version('Gtk', '3.0')
from gi.repository import Gtk, Gio

has_layershell = False
try:
    gi.require_version('GtkLayerShell', '0.1')
    from gi.repository import GtkLayerShell

    has_layershell = True
except ValueError:
    sys.stderr.write('\n\n' +
                     'If you haven\'t installed GTK Layer Shell, you need to point Python to the\n' +
                     'library by setting GI_TYPELIB_PATH and LD_LIBRARY_PATH to <build-dir>/src/.\n' +
                     'For example you might need to run:\n\n' +
                     'GI_TYPELIB_PATH=build/src LD_LIBRARY_PATH=build/src ' + 
                     ' '.join(sys.argv) + '\n')

from hiprompt_gtk.window import Window


class Application(Gtk.Application):
    def __init__(self, application_id, session):
        self.session = session

        if os.path.isfile('hiprompt.gresource'):
            sys.stderr.write("Using resources from cwd\n")
            resource = Gio.resource_load("hiprompt.gresource")
            Gio.Resource._register(resource)
        elif os.path.isfile('hiprompt_gtk/hiprompt.gresource'):
            sys.stderr.write("Using resources from cwd/hiprompt_gtk\n")
            resource = Gio.resource_load("hiprompt_gtk/hiprompt.gresource")
            Gio.Resource._register(resource)

        Gtk.Application.__init__(self, application_id=application_id)
        self.connect("activate", self.activate)

    def activate(self, *args):
        window = Window(self, self.session)

        if has_layershell and GtkLayerShell.is_supported():
            sys.stderr.write("Loading layer shell support\n")
            GtkLayerShell.init_for_window(window.window)
            window.window.set_decorated(True)
            GtkLayerShell.set_keyboard_interactivity(window.window, True)
            GtkLayerShell.set_layer(window.window, GtkLayerShell.Layer.OVERLAY)
        else:
            sys.stderr.write("Skipping layer shell\n")
        window.window.show_all()
        Gtk.main()
